/*=============================================================================
 RandomDungeon_KuroCustom.js 
----------------------------------------------------------------------------

/*:
 * @plugindesc ランダムダンジョンプラグイン くろあめ工房カスタム
 * @author くろあめ
 * @target MZ
 *
 * @help んーそーさんのランダムダンジョンプラグイン導入時に
 * NUUNさんのシンボルエンカウントプラグインが正常に動作できるよう
 * 競合解決用の処理を導入します。
 *
 * んーそーさんのランダムダンジョンプラグインは
 * NUUNさんのシンボルエンカウントプラグインより下に配置してください
 * 本プラグインはんーそーさんのランダムダンジョンプラグイン直下に配置してください
 */

(() => {

    Game_Event.prototype.initialize = function(mapId, eventId, event=null) {
        this.setSymbolEnc_kuro(eventId,event);
        Game_Character.prototype.initialize.call(this);
        this._mapId = mapId;
        this._eventId = eventId;
        this._event = event;
        const eventData = this.event();
        //console.log(eventData);
        this.locate(eventData.x, eventData.y);
        this.refresh();
    };
    
    Game_Event.prototype.setSymbolEnc_kuro = function(eventId,event) {
        if ($dataMap) {
            if ($dataMap.meta?.random) {
                if (event) {
                    this._symbolEnc = event ? Number(event.meta.SymbolEncEnemy) : 0;
                } else {
                    this._symbolEnc = 0;
                }
            } else {
                this._symbolEnc = $dataMap.events[eventId] ? Number($dataMap.events[eventId].meta.SymbolEncEnemy) : 0;
            }
        } else {
            this._symbolEnc = 0;
        }
    };

})();
